# hl7gateway changes

## 1.19.0 -- 2025-11-28

- Accept `ADT^A14` messages.
- Properly handle document title (`TXA-25`) in incoming `MDM` messages.

## 1.18.1 -- 2025-11-25

- For invalid appointment messages, reply with an `AR` rejection now.

## 1.18.0 -- 2025-11-25

- Send patient country in `PID-11-6`
- When appointments in incoming `SIU` messages are invalid, reply with an `AE` rejection instead of an error. Send validation errors in the `ERR` segment.

## 1.17.1 -- 2025-11-11

- No user-visible changes

## 1.17.0 -- 2025-11-10

- Add waitlist name in the AIS-10-4 of SIU messages

## 1.16.0 -- 2025-10-31

- Enable structured JSON logging with `samedi.log_format = "json"`
- When handling `SRM^S02` or `SRM^S03`, and the appointment is unavailable at the requested time, the gateway does not crash anymore. It only sends the rejection message with the error description.

## 1.15.0 -- 2025-10-20

- Update authentication in IMedOne API client.

## 1.14.0 -- 2025-10-15

- Add mllp listener option to automatically share documents with patient on every MDM message received (`mllp.listener.automatic_document_sharing`, default: `false`)

## 1.13.0 -- 2025-10-02

- When adding encounter ids to patients through `ADT` messages, ignore deleted patients. This would cause an error before.
- Fix an issue where `mdm_out_requires_encounter` would sometimes not work.

## 1.12.1 -- 2025-09-18

- Logging changes
  - Service output is no longer logged to the windows event log. It's only in the logfile now.
  - When run interactively, output to STDERR is now identical to the data that's written into the logfiles.

## 1.11.4 -- 2025-09-11

- Add support for form type reference in MDM messages. When generating MDM T02 messages, the system now uses form type reference for the document type (TXA-2) when present, with document request type reference taking precedence if both are available.
- Change how resource identifiers are received in `AIL` and `AIP` segments.
  - In `AIL` segments, resource identifiers are in `AIL-3-10` (Comprehensive Location Identifier)
  - In `AIP` segments, resource identifiers are in `AIP-3-1` (ID Number) and `AIP-3-9` (Assigning Authority)
  - **Breaking change**: Providing any authority value also changes the xref lookup places to `AIL-3-1-10-1` and `AIP-3-1-1-1`.

## 1.11.3 -- 2025-09-10

- Create a new patient from PID segment when ADT A40 patient merge message is received (applies only for external patients)
- iMedOne integration: Don't set patient xref, only write into patient identifiers.

## 1.11.2 -- 2025-09-03

- When the setting `mdm_out_requires_encounter` is false but the received document document from samedi is linked to an appointment, send the appointment reference in `TXA-14`

## 1.11.1 -- 2025-08-27

- Internal updates to logging. Some messages might be temporarily logged twice.
- Consider 422 error permanent in the api client, and don't retry it

## 1.11.0 -- 2025-08-22

- Fix SIU^S12 messages for appointments with forms
- Always strip leading `samedi:` from patient identifiers in outgoing HL7 messages.
- Require `imedone.patient_identifier_system` to be configured.

## 1.10.6 -- 2025-08-08

- Fix ACK messages for successful ADT^A40 patient merge requests

## 1.10.5 -- 2025-07-29

- No user-visible changes

## 1.10.4 -- 2025-07-21

- Support diverse gender.
- Crash on error when a received message can't be processed
- Fix recognizing appointment id in the `PID-3`

## 1.10.3 - 2025-07-04

- Ping platform once a minute, with all accounts even polling is turned off, just to keep connection active

## 1.10.2 - 2025-06-30

- Change how resource identifiers are sent in `AIL` and `AIP` segments.
  - In `AIL` segments, resource identifiers are in `AIL-3-10` (Comprehensive Location Identifier)
  - In `AIP` segments, resource identifiers are in `AIP-3-1` (ID Number) and `AIP-3-9` (Assigning Authority)
  - The default namespace for samedi resource identifiers is `99SAMEDI-RESOURCE&https://app.samedi.de/fhir/sid/calendar-resource-id&URI`
- Added error tracking in the statefile. When synchronization of a specific patient, appointment, or medical record entry fails, the corresponding index will be recorded in `hl7gateway-state.json` with an `_error` suffix.

## 1.10.1 - 2025-06-19

- If `mllp.listener.automatic_patient_claiming` is `true`, create a patient invite on every `ADT` message
- Fix order of resource segments in `SIU` messages.

## 1.10.0 -- 2025-06-11

- **Breaking change:** Replace `ADT^A23` with `ADT^A29` for patient deletion messages to better comply with HL7 standards
- Add `resource_types` mapping to the configuration. With this user can specify the type of resource for resource xrefs.
- Depending on `resource_types` configuration we will send AIL and AIP segments in SIU message for corresponding resources. For the resources with unspecified type we continue sending AIG.

## 1.9.4 -- 2025-06-11

- Add enhanced encounter data extraction from ADT messages. This allows extracting of:
  - Patient class extracted from `PV1-2`
  - Location extracted from `PV1-3`
  - Admission date extracted from `PV1-44`
  - Discharge date extracted from `PV1-45`
  - Planned discharge date extracted from `PV1-46`
  - Alternate visit ID (orgacard-specific) extracted from `PV1-50`

## 1.9.3 -- 2025-06-03

- Accept incoming `SIU^S23` messages.
- Add mimetype to only OBX-5-2 field on outgoing MDM messages
- Change `PID-13` field formatting:
  - For email, send email in `PID-13-4` and "NET" in `PID-13-3`.
  - For phone numbers, add unformatted phone number in `PID-13-12`.
- Send document request type xref in MDM message at TXA-2. When document request type xref is emtpy, we send the default value there: `samediDefaultType`
- Fix sometimes missing `TXA-25` field

## 1.9.2 -- 2025-05-20

- No user-visible changes

## 1.9.1 -- 2025-05-20

- Fix patient lookup when receiving an MDM message on multi account setups
- Add mimetype to `OBX-5-2` and `OBX-5-3` fields on outgoing MDM messages
- Send the access link of VC appointments in `SIU` messages.

## 1.9.0 -- 2025-04-08

- Make sure statefile is always written atomically.
- Don't send `MDM` messages when the flag `mllp.sender.mdm_out_requires_encounter` is set to true and the appointment does not have an encounter reference.
- Use enhanced acknowlege mode and always send `AL`/`NE` in `MSH-15`/`MSH-16`.

## 1.8.2 -- 2025-03-31

- No user-visible changes

## 1.8.1 -- 2025-03-25

- Send patient portal appointment id (from the portal API) in `SCH-24`.

## 1.8.0 -- 2025-03-24

- Send the "Bezugsdatum" of patient documents in `TXA-4` and `OBX-14` segments of outgoing `MDM` messages.
- Add encounter reference to `PV1-19` for outgoing `SIU` messages, if it is available
- Make iMedOne integration independent from the `appointments_polling_enabled` configuration option.

## 1.7.7 -- 2025-03-17

- Configuration `mllp.sender.use_public_appointment_id`. When set to true, we'll send patient portal appointment id as a filler id in `SCH` segment. Default is false

## 1.7.6 -- 2025-03-13

- Fix parsing SIU messages without `PID` but with `AIS` segments.
- Fix MLLP timeout logic: only start the timeout when the message is sent. This fixes a problem with timeouts when sending very large MDM messages.

## 1.7.5 -- 2025-02-27

- Support patient identifiers of the type `urn:uuid:<uuid>` (maps to `1234^^^&<uuid>&UUID` in HL& patient identifiers)
- Auto-discover HTTP proxy settings on Windows and MacOS
- Do not strip debug symbols from release builds

## 1.7.4 -- 2025-02-12

- Configuration `mappings` to store all kinds of configured mappings
- Configuration `mappings.external_patient_authority_systems` for holding recognized patient identifier authorities and corresponding identifier systems
- Recognize hl7 patient external identifiers according to configured `mappings.external_patient_authority_systems` and send them to platform. Before we recognized only those with universal id "ISO"
- Send patient external identifiers in PID-3
- Handle ADT_A40 patient merge message, new mllp listener configuration value called `patient_merge_adt_a40_enabled` is available to turn this feature on (disabled by default)

## 1.7.3 -- 2025-01-24

- No user-visible changes

## 1.7.2 -- 2025-01-20

- Send `MDM` messages for institutions with the antivirus package active only when they were scanned and the scan passed.
- Populate `TXA-14` field on outgoing `MDM` messages if appointment reference is available.
- Option value `patient_merge_adt_a40_enabled` to toggle handling patient merge with `ADT_A40` message, defaults to `false`
- Associate encounter with patient in ADT handler
- Upgrade dependencies

## 1.7.1 -- 2024-12-10

- Upgrade dependencies

## 1.7.0 -- 2024-12-04

- **Breaking changes**
  - Outgoing `SIU` messages now reflect the appointment status more directly.
    - `SCH-25` previously was only `Booked` or `Deleted`. Now it can be any Filler Status Code. ([Table 0278](https://terminology.hl7.org/CodeSystem-v2-0278.html))
  - When parsing `PID` segments, samedi patient ids are only recognized when assigning authority is `&www.samedi.de&DNS`. The Universal ID Type `DNS` used to be optional and is now required.
  - `SIU` messages that contain a samedi appointment ID in the `SCH` segment (an id in the configured `samedi.appointments_namespace`) are rejected with an `AE` error unless they contain an account ID in `PV1-19`.
- Support for incoming `ADT^A31` messages.
- Support for `PV1-19` in incoming `SIU` messages.
- Support for associating appointments with cases through incoming `ADT` messages. When an `ADT` message has an _appointment ID_ in `PID-3`, the `PV1-19` visit number will be associated with that appointment.

## 1.6.1 -- 2024-11-12

- No user-visible changes

## 1.6.0 -- 2024-10-24

- Upgrade dependencies

## 1.5.0 -- 2024-10-18

- Set `PV1-2` segment to `U` for `MDM` messages
- When syncing, sync all resource types (patients, appointments, etc) in parallel, not sequentially

## 1.4.0 -- 2024-09-28

- Send multiple values for a single comment field outgoing `SIU` message `NTE` segments as repetition. (separated by `~`) Previously, multi-selections would be separated by commas.

## 1.3.0 -- 2024-09-19

- Query patients by their identifiers before posting new appointments from incoming SIU^S12

## 1.2.6 -- 2024-07-30

- On startup, log all mapped resource xrefs

## 1.2.5 -- 2024-07-17

- Fix a crash when processing SRM messages where the referenced patient did not have an xref

## 1.2.4 -- 2024-07-15

- No user-visible changes

## 1.2.3 -- 2024-07-15

- Change logging of incoming HL7 messages to make it easier to understand [HL7-403]

## 1.2.2 -- 2024-07-03

- Fix logging of incoming HL7 messages with non-UTF-8 encoding

## 1.2.1 -- 2024-06-12

- Improve logging of incoming and outgoing messages
- Upgrade dependencies

## 1.2.0 -- 2024-04-24

- Change in build tooling. No changes for end users

## 1.1.0 -- 2024-04-15

- Add support for mTLS incoming and outgoing connections in HL7Gateway

## 1.0.8 -- 2024-03-18

- Fix an issue where sending MDM messages for clinic-uploaded files would not work.

## 1.0.6 -- 2024-03-11

- Fix an issue where a patient wasn't updated from an ADT message when only the xref has changed.

## 1.0.3 -- 2024-02-19

- Drop PV1 segments without comments on MLLP messages
- Support TLS over MLLP with new config options

## 1.0.2 -- 2024-01-16

- Remove hl7send.exe and hl7listener.exe debugging tools from MSI installer, as those created false alerts in several virus scanners

## 1.0.1 -- 2023-10-26

- Handle `NTE` segments in incoming SIU messages

## 1.0.0 -- 2023-10-16

- Update code signing certificate
- **BREAKING CHANGE**: SIU^S13: correctly mark RGS / AIG segments as removed, added or unchanged (before, we removed all blocks, then re-added them again)
- Add support for updating waitlist status via SRM messages (via setting AIS.10)
- Outgoing SIU messages contain AIS.10 with the appointment waitlist status

## 0.36.0 -- 2023-08-04

- Remove support for DIM-Client (project ended)
- Remove support for apomondo adapter (project ended)
- Add option to define whether an encounter is required for MDM-Out (defaults to `true`)
- Accept multiple values for a single comment field in incoming `SRM` messages

## 0.35.0 -- 2023-06-20

- When updating patient data, keep additional patient attributes intact

## 0.34.0 -- 2023-05-22

- When generating `SIU` messages, only send messages when they have least one `AIG` segment.
- Make logged HL7 messages more readable with newlines

## 0.33.0 -- 2023-05-08

- When sending SRM messages, include `TXA-12` and `TXA-16`.

## 0.32.0 -- 2023-05-02

- When handling SRM messages, set or update patient xref when needed.

## 0.31.0 -- 2023-03-27

- Only send MDM messages when documents have a case ID

## 0.30.0 -- 2023-03-14

- Accept `PV1-19` as encounter information

## 0.29.0 -- 2023-03-09

- Changes in some API integrations

## 0.28.1 -- 2023-02-13

- Fix an issue where `PID` messages would include an empty public identifier in some cases

## 0.28.0 -- 2022-12-18

- Implement routing of HL7-messages based on receiving facility. (`MSH-6`)
  - When `samedi.accounts.{account-name}.hl7_facility` is set to some value, incoming HL7 messages will be routed only to accounts when the value in MSH-6 matches the configured value.
  - Messages that cannot be routed to any account will be rejected.
- HL7 Acknowledgements (MSA messages), now echo SendingFacility, ReceivingFacility, SendingApplication, ReceivingApplication (`MSH-3`, `MSH-4`, `MSH-5`, `MSH-6`) from the received message, not from the configuration.

## 0.27.0 -- 2022-12-06

- DIM client: add new vaccines added in DIM release 2.11:
  - Spikevax bivalent Original/Omicron BA.1 ("Spikevax 0 (Zero)/O (Omicron)" is still accepted)
  - Spikevax bivalent Original/Omicron BA.4-5
  - Jcovden ("janssen" is still accepted")
  - VidPrevtyn Beta
  - Valneva

## 0.26.6 -- 2022-12-01

- No user-visible changes

## 0.26.5 -- 2022-11-24

- No user-visible changes

## 0.26.4 -- 2022-11-07

- No user-visible changes

## 0.26.3 -- 2022-11-03

- No user-visible changes

## 0.26.0 -- 2022-11-01

- Introduce `request_timeout_seconds` configuration option.
- Upgrade dependencies

## 0.25.0 -- 2022-09-26

- DIM client: add support for new BA.4-5 ("Omicron") vaccines:
  - Comirnaty Original/Omicron BA.4-5

## 0.24.0 -- 2022-09-12

- DIM client: add support for new BA.1 ("Omicron") vaccines:
  - Comirnaty Original/Omicron BA.1
  - Spikevax 0 (Zero)/O (Omicron)

## 0.23.4 -- 2022-08-30

- Improve error logging

## 0.23.3 -- 2022-06-10

- Fix an error on `https://hl7gateway.samedi.de/hl7gateway/messages/mdm/`, `PID-3` is required, not `PID-4`.

## 0.23.2 -- 2022-05-19

## 0.23.1 -- 2022-05-18

- Minor changes in log output formatting

## 0.23.0 -- 2022-04-25

- DIM client: remove `stiko_*` fields which are deprecated since DIM release 2.6

## 0.22.4 -- 2022-03-28

## 0.22.2 -- 2022-01-13

- Fix an issue where patient birthdates were sometimes not parsed correctly.
- Fix an issue where the windows service would not be restarted correctly on failure.

## 0.22.0 -- 2022-01-11

- Changed how error reporting works. Errors are now reported to a samedi-hosted Sentry (sentry.io) instance.
  - This can be disabled by setting the `SENTRY_DSN` environment variable to an empty string or to your own endpoint.
- Example config file is now located in data directory instead of install directory.

## 0.21.0 -- 2021-12-09

- Support writing chunked medical record attachments from incoming `MDM` messages.

## 0.20.14 -- 2021-11-30

- Support reading chunked medical record attachments. HL7 is now compatible with streamed MRE uploads on platform.

## 0.20.11 -- 2021-11-25

- Update the way medical record attachments are fetched from samedi for MDM messages

## 0.20.8 -- 2021-10-13

- Fix loading Form data for DIM reporting client
- Normalize vacc_product for DIM reporting

## 0.20.7 -- 2021-10-04

## 0.20.1 -- 2021-08-24

- Handle `ADT^A01` and `ADT^A04` messages.

## 0.20.0 -- 2021-08-03

- Add dim-client releases

## 0.19.3 -- 2021-06-29

- Stop shipping zoneinfo.zip because it is no longer required.
- Upgrades of internal dependencies.

## 0.19.2 -- 2021-01-20

- Fix an issue where MDM messages would use the wrong key to encrypt files

## 0.19.1 -- 2021-01-04

- pretty-print JSON in hl7gateway-state.json

## 0.19.0 -- 2020-12-15

- `hl7_version` in the configuration is no longer ignored.
- `MSA` message replies now echo the HL7-version (`MSH-11`) of the incoming message.
- Changed RSA key handling in the samedi API

## 0.18.3 -- 2020-10-13

- Strip linefeeds (`\r`) from message contents.

## 0.18.2 -- 2020-08-24

- Make sure to handle incoming messages serially for each listener to avoid race conditions with messages for the same appointment sent through different connections at the same time.

## 0.18.1 -- 2020-05-14

- Fall back to reading patient ids from `PID-2` when `PID-3` does not have data.

## 0.18.0 -- 2020-05-07

- Introduce new configuration option `log_file_backups`. (default: 3)
- Make samedi API calls robust against IDs being strings vs. numbers.

## 0.17.4 -- 2020-01-07

- Support notifications for cancellations through `SRM^S04` and `SRM^S05` messages

## 0.17.3 -- 2019-12-19

- Support sending notifications in SRM without a PID segment when updating existing appointments.

## 0.17.2 -- 2019-12-16

- Moved the public website to [hl7gateway.samedi.de](https://hl7gateway.samedi.de)

## 0.17.0 -- 2019-11-29

- Support for sending notifications when creating or updating appointments with `notify^true` in `AIS-12`
- Include `ERR` segment for `ACK` messages on ApplicationError and ApplicationReject

- Use `\r\n` line endings when logging on windows
- Fix `hl7_facility` for outgoing HL7 messages. When `hl7_facility` is configured for a samedi account,
  it will now correctly be sent in `MSH-4` (default is `samedi`)

## 0.16.1 -- 2019-10-22

- Support incoming `SRM^S04` and `SRM^S05` messages (appointment cancellation)

## 0.16.0 -- 2019-10-15

- Send `MDM^T02` messages for medical record entries that are created in samedi for patients
  - added a new configuration option `medical_record_polling_enabled` to enable this per samedi account.

## 0.15.0 -- 2019-09-09

- Support for incoming `MDM^T02` messages.

## 0.14.0 -- 2019-08-07

- Support for configuring `receiving_application` and `receiving_facility` (`MSH-5`, `MSH-6`) per connection for outgoing HL7 messages.

## 0.13.7 -- 2019-06-20

- FIXED: patients where zip, phone numbers or insurance number encrypted as integers would crash the gateway.

## 0.13.6 -- 2019-06-03

- Use `99SAMEDI-RESOURCE` instead of `SAMEDI-RESOURCE` in `AIG-3-3` to not generate invalid HL7 messages. `SAMEDI-RESOURCE` is still accepted in incoming `AIG`/`AIL`/`AIP` segments.

- FIXED: patients with "insurance_company" set to "public" or "private" would break during ADT message handling.

## 0.13.5 -- 2019-05-21

- Support `AIP`/`AIL`/`AIG` segments in `SRM` messages: When updating an existing appointment in samedi with an `SRM` message, it's now possible to override the booking logic by sending appropriate resource segments. This updates the booked resources on that appointment to be exactly as sent.

## 0.13.4 -- 2019-05-20

- Add a configuration option `mllp.sender.peer_error_handling = "ignore"`. If set, the program will not terminate when it receives a MSA message with `AE` or `CE` status and the message will not be retried.

## 0.13.3 -- 2019-05-15

- hl7gateway instances now periodically announce their status when running normally.

## 0.13.2 -- 2019-05-14

- Moved default configuration into non-roaming `%ProgramData%`.
- Add a Start Menu shortcut for program and configuration directories.

- FIXED: multiple incoming connections on the same channel work now.
- FIXED: service restart would sometimes not work when there were network errors during program initialization.
- FIXED: logging to the windows event log didn't work.

## 0.13.1 -- 2019-05-02

- Note: existing integrations that send `SIU` messages to samedi with `AIG-3-4`, `AIL-3-4` or `AIP-3-4` need to be updated to keep this field empty or to have an actual resource xref there (this field was previously ignored).

- Change parsing of incoming `AIG`/`AIL`/`AIP` segments.

  - `AIG-3-1` can now describe a samedi Resource ID. For this `AIG-3-3` must have the value `SAMEDI-RESOURCE`
  - If `AIG-3-4` is set, it will be interpreted as samedi resource xref. This will always take precedence over `AIG-3-1`. (the same applies to `AIL` and `AIP` segments)
  - Accordingly, in outgoing `SIU` messages, `AIG-3-3` is now set to `SAMEDI-RESOURCE` to indicate that `AIG-3-1` is a resource ID, not a resource xref

- Save access token in the state file by account name instead of user name

## 0.13.0 -- 2019-04-29

- hl7gateway instances now use an access token to authenticate themselves with app.samedi.de

## 0.12.9 -- 2019-04-17

- Duration is calculated differently for appointment types that are configured with negative start offsets
- Moved the public website to [repo.samedi.de/hl7gateway](https://repo.samedi.de/hl7gateway)

## 0.12.6 -- 2019-04-05

- FIXED: do not send patients birthdate in outgoing PID segments when it is before the year 1900.
- FIXED: when an xref was used in different resources across multiple samedi accounts it would only be associated with a single account.

- Support multiple independent MLLP connections.
- Remove `dump_dir` configuration option to write HL7 messages to a directory. Use `samedi.log_file` to log messages.

## 0.12.5 -- 2019-04-02

- Skip patient birthdate in PID, when the year is less than 1900

## 0.12.4 -- 2019-03-26

- Use ".br" escape sequence instead of newlines when sending messages to KIS

## 0.12.3 -- 2019-03-21

- Do not attempt to book appointments into ressources that are shared from another account.

## 0.12.2 -- 2019-03-20

- Add `samedi.log_file` configuration option.

## 0.12.1 -- 2019-03-06

- Support more fields in `SRM-S02` messages:
  - Allow ignoring availability calculations when updating appointments with `force^yes` in `APR-5`.
  - Support updating appointment duration with `ARQ-9`/`ARQ-10`.

## 0.12.0 -- 2019-02-26

- Support incoming `SRM^S02` messages for updating appointments in samedi.
- Don't send U+200C characters in NTE fields of appointment comments.
- Make UTF-8 the default MLLP message encoding for new installations

## 0.11.0 -- 2019-02-05

- Use `MSH-9-1` and `MSH-9-2` exclusively for recognizing messages. Stop using `MSH-9-3` (Message Structure)
  - SIU-Messages now don't need to include `SUI_S12` in `MSH-9-3` any more.
  - Only `S12` - `S15` messages are now handled. Older versions would silently accept other types of SIU-Messages.
- outgoing `SIU` messages now send `AIG||X` segments inside an `RGS||X` group for each unchanged resource in an appointment.
- FIXED: SIU messages now always contain at least one RGS segment.

## 0.10.4 -- 2019-01-15

- FIX: listen for shutdown signal even while syncing is not yet finished
- Send `recreate_if_exists` parameter for events when creating them.
  When gateway sends a request to create an event, in case the event with
  such xref already exists, platform will cancel it and create a new event
  with that xref.

## 0.10.3 -- 2018-11-20

- FIX: put outgoing appointment namespace in SCH-2-2 as described, not SCH-2(2)-1

## 0.10.2 -- 2018-11-20

- Add a configuration option `patients_polling_enabled` to disable sending of ADT messages
- Add a configuration option `appointments_polling_enabled` to disable sending SIU messages
- deprecated `polling_enabled` configuration option, which now disables outgoing ADT and SIU messages.

## 0.10.1 -- 2018-11-15

- Add a configuration option "appointments_namespace" to "samedi" section. When present, this
  will be put to SCH-2-2 of outgoing SIU messages.

## 0.10.0 -- 2018-11-06

- Drop support for service installation in Unix/macOS.
- Make windows service handling more robust:
  - Add a command line option "workingDirectory" to make relative paths in configuration work. (they would be relative to "%WINDIR%/System32" before)
  - Log errors during startup to Windows EventLog.
  - Configure automatic restart of the service during installation.
- MLLP: don't attempt to connect automatically during startup. Connect when the first message needs to be sent.

## 0.9.0 -- 2018-11-02

- retry network requests to make the program more robust
- Support "enhanced mode" for Acknowledgements, allow outgoing messages to be acknowledged with CA/CR/CE codes in addition to AA/AR/AE.

## 0.8.3 -- 2018-10-30

- Include hl7 specification and changelog

## 0.8.2 -- 2018-10-26

- Fix merging of non-existent patient by id but by xref

## 0.8.0 -- 2018-10-18

- when updating patient after ADT message from KIS do not erase any data in samedi patient record

## 0.7.0 -- 2018-10-02

- do not re-update patients in samedi if the data did not change in order to prevent loops
- poll for patient updates in samedi and send out ADT Messages
  - `ADT^A08` for patients that are created/updated
  - `ADT^A23` messages for patients that are deleted

## 0.6.0 -- 2018-09-20

- accept `ADT^A08` Message type and allow patients to be created and updated
- accept local phone number on PID-13

## 0.5.7 -- 2018-09-10

- fix born_on parsing

## 0.5.6 -- 2018-06-07

- Add release build for macOS

## 0.5.5 -- 2018-05-03

- Support PID fields in SIU messages.

## 0.5.0 -- 2018-04-10

- Require the 'hl7gateway' package in all connected samedi accounts.
- Appintment updates now send all resource changes, not the current state of the appointments.
  - A moved appointment will have an `RGS||D` part with removed resources and an `RGS||A` part with added resources.
  - Cancelled appointments now send `AIG||D` segments for the booked resources.
  - Segment IDs in AIG-1 and RGS-1 now increment instead of always being `1`.
- Send "DELETED" instead of "BOOKED" in SCH-6 field for S15 messages.

## 0.4.14 -- 2018-03-19

- Add HTTP[S]\_PROXY support. Use the proxy server given in the HTTPS_PROXY or HTTP_PROXY environment variable.

## 0.4.13 -- 2018-03-16

- Add `hl7send` tool for sending single messages from text files.

## 0.4.12 -- 2018-03-14

- send patient address in PID-11 (street, city, zip)
- send patient email address in PID-13 (type X.400)
- send patient phone numbers in PID-13 (PC: mobile number, PH: phone, PX: fax)

## 0.4.11 -- 2018-03-06

- Build a distributable linux archive on CI

## 0.4.10 -- 2018-02-23

- Make HL7 message IDs non-deterministic.

## 0.4.9 -- 2018-02-23

- Make timeout configurable with `config.mllp.sender.acknowledge_timeout_seconds` configuration option.
- Only start acknowledgement timeout when HL7 message is about to be sent and never run multiple timeouts in parallel.

## 0.4.8 -- 2018-02-22

- Increase timeout when waiting for HL7 message acknowledgements to 30 seconds. (from 10 seconds)
- Load practice encryption keys immediately on startup, not only when required.

## 0.4.7 -- 2018-02-16

- fixed: patients from referrals that are encrypted with a public key are decrypted correctly now.

## 0.4.6 -- 2018-02-12

- data that can't be represented with the chosen HL7 message encoding will have non-encodable bytes replaced with a replacement character. (0x1A for ISO 8859-1) Before, the HL7 component would be skipped entirely.

## 0.4.5 -- 2018-02-08

- installer: Create a batch file in "%APPDATA%/samedi HL7gateway" for a better first-run experience.
- installer: Ship util/hl7listener.exe for easier debugging.

## 0.4.4 -- 2018-02-07

- always set RGS-2 in outgoing SIU-messages (segment action code)
- SIU-Messages always send message structure SIU_S12
- send TQ1 segments for appointment time
- allow setting structured MSH message headers in configuration file
- DEPRECATION: consumers should use TQ1-7 and TQ1-13 instead of SCH-11 and SCH-9

## 0.4.3 -- 2018-02-05

- send gender in PID messages
- bundle zoneinfo.zip in windows installer so that loading timezones works there
- don't generate NTE segments for empty appointment comments

## 0.4.2 -- 2018-02-05

- fix parsing of patient data where birthdate is a timestamp
- fix that invalid birthdates would get sent as "00010101" in PID segments

## 0.4.1 -- 2018-02-02

- send "Deleted" in SCH-25 for deleted appointments

## 0.4.0 -- 2018-02-02

- HL7 message segments are separated by CR (\r) instead of LF (\n) for conformance with the HL7 specification.
- Send out S12/S13/S14/S15 messages, compatible with java HL7gateway with the following differences:
  - HL7 Version declared in MSH header defaults to 2.5
  - MSH sending facility is different. "HL7Gateway^samedi.de^DNS|scheduling^samedi.de^DNS" now is "samedi-hl7gateway|samedi"
  - Comment field names are sent as-is. Existing mappings do not work any more.
  - Charset defaults to "8859/1" and is always sent in all messages.
  - Add three utility scripts
    - "service-install-hl7gateway.bat", "service-uninstall-hl7gateway.bat" for installing and removing the service (run as Administrator)
    - "utils/tail-service-log.ps1" to more easily look at log output of the running service.
- wait for ACK/NACK replies when sending out SIU messages
- report an error when config file contains unknown configuration options
- configurable sync interval (set with `config.samedi.polling_interval_seconds = 60`)
- new option to disable outgoing HL7 messages per samedi account `polling_enabled = false`

## 0.3.1 -- 2018-01-16

- better debug output: log HTTP response body for failed requests.

## 0.3.0 -- 2018-01-03

- read samedi practice ID from incoming SIU S14 messages if one is set.
  This makes hl7gateway work with multiple configured accounts when updating appointments is required.
- Remember which samedi appointments have already been imported.
  (With new `samedi.state_file` configuration option, which defaults to hl7gateway-state.json in the current directory.)

## 0.2.6 -- 2017-12-11

- Handle SIU S14 messages from Orbis and put Orbis Case-ID and Patient ID into samedi appointment comments.

## 0.2.5 -- 2017-12-08

- parse appointment time out of SIU messages when there are no TQ1 segments.

## 0.2.3 -- 2017-12-01

- Don't exit program when an incoming HL7 messages can not be assigned to any configured samedi account.

## 0.2.2 -- 2017-11-30

- Handle AIP/AIL/AIG segments in SIU messages.
- Send NACK replies for messages that can't be handled.
- Fixed: upgrading with the MSI installer uninstalls old version.

## 0.2.1 -- 2017-11-24

- New `dump_dir` configuration option to log all HL7 messages into files.
- Fixed: SIU messages with appointment times in TQ1 are parsed correctly now.
- Fixed: make disabling outgoing HL7 connections actually work.

## 0.2.0 -- 2017-11-23

- Add windows installer.
- Ability to run as a windows service.

## 0.0.1 -- 2017-11-16

- initial version
